#include "lib0970.h"
#include <bits/stdc++.h>
using namespace std;

namespace 
{
void judge_error(int code) { cout << "Judge Error [" << code << "]\n"; exit(0); }
void wrong_answer(int code) { cout << "Wrong Answer [" << code << "]\n"; exit(0); }

const int maxc = 1 << 22;
}


int main() {
    int n, L; cin >> n >> L;
    
    vector<int> a(n);
    for (int &x : a) cin >> x;
    
    if (not is_sorted(a.rbegin(), a.rend())) {
        judge_error(1); // a[] is not sorted from large to small
    }
    
    if (a[0] >= maxc) {
        judge_error(2); // there exists a[i] >= maxc
    }
    
    if (a[n-1] <= 0) {
        judge_error(3); // there exists a[i] <= 0
    }
    

    string s = Alice(n, L, a);
    cerr << "[Alice] s = \"" << s << "\"\n";
    if ((int)s.size() > L) {
        wrong_answer(4); // the length of s is greater than L
    }
    
    for (char c : s) if (not (c == '0' or c == '1')) {
        wrong_answer(5); // s contains characters not in {'0', '1'}
    }
    
    vector<string> H = Bob(s);
    for (int i = 0; i < (int)H.size(); ++i) {
        cerr << "[Bob] h[" + to_string(i) + "] = \"" << H[i] << "\"\n";
    }
    
    if ((int)H.size() != n) {
        wrong_answer(6); // size of H is not equal to n
    }
    
    for (int i = 0; i < n; ++i) for (char c : H[i]) if (not (c == '0' or c == '1')) {
        wrong_answer(7); // h[i] contains characters not in {'0', '1'}
    }
    
    for (int i = 0; i < n; ++i) for (int j = 0; j < n; ++j) if (i != j) {
        if ((int)H[i].size() <= (int)H[j].size() and H[i] == H[j].substr(0, (int)H[i].size())) {
            wrong_answer(8); // h[i] is a prefix of h[j]
        }
    }
    
    int64_t user_cost = 0;
    for (int i = 0; i < n; ++i) {
        user_cost += (int)H[i].size() * a[i];
    }
    
    cout << "The length of s is " << (int)s.size() << " and the cost is " << user_cost << ".\n";
}
