#include "lib0922.h"
#include <cstdio>
#include <vector>
#include <utility>
#include <string>
#include <cassert>

namespace {
    const int MAXQ = 250000;
    int current_testcase = 0;
    int qcnt = 0;
    std::vector<std::vector<std::pair<int, int>>> convexA, convexB;
    void wrong_answer(const std::string &msg) {
        printf("Wrong Answer: %s\n", msg.c_str());
        exit(0);
    }
}

long long get_distance(int i, int j) {
    qcnt += 1;
    if (qcnt > MAXQ)
        wrong_answer("too many queries");
    auto &A = convexA[current_testcase];
    auto &B = convexB[current_testcase];
    if (i < 0 || i >= int(A.size()) || j < 0 || j >= int(B.size()))
        wrong_answer("invalid call"); 
    return calculate_distance(A[i].first, A[i].second,
                              B[j].first, B[j].second,
                              B[(j + 1) % int(B.size())].first, B[(j + 1) % int(B.size())].second);
}

int main() {
    int T;
    assert(scanf("%d", &T) == 1);
    convexA.resize(T), convexB.resize(T);
    for (int i = 0; i < T; ++i) {
        int N, M;
        assert(scanf("%d", &N) == 1);
        convexA[i].resize(N);
        for (auto &[x, y] : convexA[i]) {
            assert(scanf("%d %d", &x, &y) == 2);
        }
        assert(scanf("%d", &M) == 1);
        convexB[i].resize(M);
        for (auto &[x, y] : convexB[i]) {
            assert(scanf("%d %d", &x, &y) == 2);
        }
    }

    std::vector<int> num_q(T);
    std::vector<std::vector<long long>> result(T);
    for (int i = 0; i < T; ++i) {
        current_testcase = i, qcnt = 0;
        result[i] = find_minimum_distances(int(convexA[i].size()), int(convexB[i].size()));
        num_q[i] = qcnt;
        if (result[i].size() != convexB[i].size())
            wrong_answer("invalid return value");
    }
    for (int i = 0; i < T; ++i) {
        printf("Accepted: %d\n", num_q[i]);
        for (int j = 0; j < int(result[i].size()); ++j)
            printf("%lld\n", result[i][j]);
    }
}
